﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.Utilities;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for MiscItems.xaml
    /// </summary>
    public partial class AddDesignerInfo : Window
    {
        public AddDesignerInfo()
        {
            InitializeComponent();
            txtDesignerName.Focus();
        }

        private void btnSave_Click(object sender, RoutedEventArgs e)
        {
            if (ValidateValues())
            {
                AppSession.CurrentOrders.DesignerName = txtDesignerName.Text.Trim();
                AppSession.CurrentOrders.DesignerRemarks = txtRemarks.Text.Trim();
                this.Tag = true;
                this.Close();
            }
        }

        private bool ValidateValues()
        {
            if (!ValidationUtility.ValidateString(txtDesignerName.Text.Trim()))
            {
                MessageBox.Show("Please enter Designer Name", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                txtDesignerName.Focus();
                return false;
            }

            return true;
        }

        private void btnCancel_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }
    }
}
